/*
 * Beverage.java
 *
 * Created on March 31, 2007, 5:35 PM
 *
 * Beverage superclass for decorator pattern
 */

package decoratorprogram;


/*
 *  Superclass for Decorator pattern
*/
public abstract class Beverage
{   
    /*
     * Defined method to calculate and return the cost of a Beverage
    */
    abstract double Cost();
}

/*
 * Beverage concrete class
*/
class HouseBlend extends Beverage
{
    public double Cost()
    {
	return 1.40;
    }
}

/*
 * Beverage concrete class
*/
class DarkRoast extends Beverage
{
    public double Cost()
    {
	return 1.50;
    }
}

/*
 * Beverage concrete class
*/
class Decaf extends Beverage
{
    public double Cost()
    {
	return 1.05;
    }
}

/*
 * Beverage concrete class
*/
class Espresso extends Beverage
{
    public double Cost()
    {
	return 1.80;
    }
}